/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.fmtwidgets;

import com.quantumdata.fmteditor.fmt.CmdValue;
import com.quantumdata.fmteditor.fmtwidgets.FmtComboBox;
import com.quantumdata.fmteditor.fmtwidgets.NamedValue;

public class VideoKindComboBox
extends FmtComboBox {
    private static final long serialVersionUID = 1L;
    private CmdValue m_avst;
    private CmdValue m_dvst;
    private boolean m_starting = true;

    public VideoKindComboBox(CmdValue cmdValue, CmdValue cmdValue2) {
        super((CmdValue)null);
        this.m_avst = cmdValue;
        this.m_dvst = cmdValue2;
        int n = cmdValue.getEnumValues().length + cmdValue2.getEnumValues().length;
        NamedValue[] namedValueArray = new CMEntry[n + 1];
        namedValueArray[0] = new CMEntry(false, new NamedValue("Default", 0));
        int n2 = 1;
        for (NamedValue namedValue : cmdValue.getEnumValues()) {
            namedValueArray[n2++] = new CMEntry(true, namedValue);
        }
        for (NamedValue namedValue : cmdValue2.getEnumValues()) {
            namedValueArray[n2++] = new CMEntry(false, namedValue);
        }
        this.setEnumValues(namedValueArray);
        if (this.m_avst.getInt() != 0) {
            this.select(this.m_avst.getInt(), true);
        } else if (this.m_dvst.getInt() != 0) {
            this.select(this.m_dvst.getInt(), false);
        } else {
            this.setSelectedIndex(0);
        }
        this.m_starting = false;
    }

    protected void selectionChanged() {
        if (this.m_starting) {
            return;
        }
        CMEntry cMEntry = (CMEntry)this.getSelectedItem();
        if (cMEntry == null) {
            return;
        }
        if (cMEntry.value() == 0) {
            this.m_avst.setInt(0);
            this.m_dvst.setInt(0);
        }
        if (cMEntry.isAnalog) {
            this.m_avst.setInt(cMEntry.value());
            this.m_dvst.setInt(0);
        } else {
            this.m_dvst.setInt(cMEntry.value());
            this.m_avst.setInt(0);
        }
    }

    protected void select(int n, boolean bl) {
        for (int i = 0; i < this.getItemCount(); ++i) {
            CMEntry cMEntry = (CMEntry)this.getItemAt(i);
            if (cMEntry.isAnalog != bl || cMEntry.value() != n) continue;
            this.setSelectedIndex(i);
            return;
        }
    }

    private static class CMEntry
    extends NamedValue {
        public boolean isAnalog;

        public CMEntry(boolean bl, NamedValue namedValue) {
            super(namedValue.name(), namedValue.value());
            this.isAnalog = bl;
        }
    }
}

